// FileManagerWindow.cpp : implementation file
//

#include "stdafx.h"
#include "SC590.h"
#include "SC590Dlg.h"
#include "SetupDialog.h"
#include "FileManagerWindow.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFileManagerWindow

extern VOID SC590_DEBUG( TCHAR * fmt, ... );

CFileManagerWindow::CFileManagerWindow()
{
}

CFileManagerWindow::~CFileManagerWindow()
{
}


BEGIN_MESSAGE_MAP(CFileManagerWindow, CWnd)
	//{{AFX_MSG_MAP(CFileManagerWindow)
	ON_WM_ERASEBKGND()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFileManagerWindow message handlers

void CFileManagerWindow::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	// Do not call CWnd::OnPaint() for painting messages
}

BOOL CFileManagerWindow::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	ULONGLONG n_start_search_system_times = m_nStartSearchSystemTime;

	ULONGLONG n_stop_search_system_times = m_nStopSearchSystemTime;

	CRect rect_client; GetClientRect( &rect_client );

	CBrush brush_gray(  RGB( 236, 233, 216 ) );

	CBrush brush_light( RGB(   0, 128, 255 ) );

	CBrush brush_blue(  RGB(  16,  16, 128 ) );

	CBrush brush_green( RGB(  32, 192,  32 ) );

	CBrush brush_red(   RGB( 255,  16,  16 ) );

	CDC oMemoryDC; oMemoryDC.CreateCompatibleDC( pDC );

	CBitmap oMemoryBitmap; oMemoryBitmap.CreateCompatibleBitmap( pDC, rect_client.Width(), rect_client.Height() );

	oMemoryDC.SelectObject( &oMemoryBitmap );

	// DRAW BACKGROUND (GRAY) + EXPORT SELECTION BAR (LIGHT BLUE)
	//
	{	if( m_nStartExportPoint != m_nStopExportPoint ) {

			CRect rect_child = rect_client;

			ULONG po = (m_nStartExportPoint < m_nStopExportPoint) ? m_nStartExportPoint : m_nStopExportPoint;

			ULONG pe = (m_nStartExportPoint > m_nStopExportPoint) ? m_nStartExportPoint : m_nStopExportPoint;

			// BACKGROUND (GRAY)
			//
			rect_child.left = 0;

			rect_child.right = po;

			oMemoryDC.FillRect( &rect_child, &brush_gray );

			// EXPORT SELECTION BAR (LIGHT BLUE)
			// 
			rect_child.left = po;

			rect_child.right = pe;

			oMemoryDC.FillRect( &rect_child, &brush_light );

			// BACKGROUND (GRAY)
			//
			rect_child.left = pe;

			rect_child.right = rect_client.right;

			oMemoryDC.SelectObject( &brush_gray );

			oMemoryDC.FillRect( &rect_child, &brush_gray );
		}
		else {

			CRect rect_child = rect_client;

			// DRAW BACKGROUND (GRAY)
			//
			oMemoryDC.FillRect( &rect_child, &brush_gray );
		}
	}

	rect_client.bottom -= 2;

	oMemoryDC.MoveTo( 0, rect_client.bottom );

	oMemoryDC.LineTo( rect_client.right, rect_client.bottom );

	// DRAW CURRENT RECORD FILE BAR (GREEN)
	//
	{	CRect rect_child = rect_client;

		SYSTEMTIME s_system_times; GetLocalTime( &s_system_times );

		ULONGLONG n_start_system_time = m_nLastSyncSystemTime;

		ULONGLONG n_stop_system_time = 0; SystemTimeToFileTime( &s_system_times, (FILETIME *)(&n_stop_system_time) );

		ULONGLONG po = ((n_start_system_time - n_start_search_system_times) * rect_client.Width()) / (n_stop_search_system_times - n_start_search_system_times);

		ULONGLONG pe = ((n_stop_system_time - n_start_search_system_times) * rect_client.Width()) / (n_stop_search_system_times - n_start_search_system_times) + (1);

		rect_child.left = (ULONG)(po);

		rect_child.right = (ULONG)(pe);

		oMemoryDC.FillRect( &rect_child, &brush_green );
	}
	// DRAW OLD RECORD FILES BAR (BLUE) + PLAYBACK LINE (RED)
	//
	if( m_pFileInfoList[ 0 ]->GetSize() > 0 || 

		m_pFileInfoList[ 1 ]->GetSize() > 0 || 

		m_pFileInfoList[ 2 ]->GetSize() > 0 || 

		m_pFileInfoList[ 3 ]->GetSize() > 0 ) {

		CRect rect_child[ 4 ] = { rect_client, rect_client, rect_client, rect_client }; // CH01 / CH02 / CH03 / CH04

		rect_child[ 0 ].bottom = rect_child[ 0 ].top + rect_client.Height() / 4;

		rect_child[ 1 ].top = rect_child[ 0 ].bottom;

		rect_child[ 1 ].bottom = rect_child[ 1 ].top + rect_client.Height() / 4;

		rect_child[ 2 ].top = rect_child[ 1 ].bottom;

		rect_child[ 2 ].bottom = rect_child[ 2 ].top + rect_client.Height() / 4;

		rect_child[ 3 ].top = rect_child[ 2 ].bottom;

		rect_child[ 3 ].bottom = rect_child[ 3 ].top + rect_client.Height() / 4;

		// OLD RECORD FILES BAR (BLUE)
		// 
		for( ULONG i = 0 ; i < 4 ; i++ ) {

			for( ULONG j = 0 ; j < (ULONG)(m_pFileInfoList[ i ]->GetSize()) ; j++ ) {

				ULONGLONG n_start_system_time = m_pFileInfoList[ i ]->ElementAt( j ).m_nFileStartTime;

				ULONGLONG n_stop_system_time = m_pFileInfoList[ i ]->ElementAt( j ).m_nFileStopTime;

				LONG po = (LONG)(((n_start_system_time - n_start_search_system_times) * rect_client.Width()) / (n_stop_search_system_times - n_start_search_system_times));

				LONG pe = (LONG)(((n_stop_system_time - n_start_search_system_times) * rect_client.Width()) / (n_stop_search_system_times - n_start_search_system_times)) + (1);

				if( n_start_system_time < n_start_search_system_times ) { po = 0; }

				rect_child[ i ].left = po;

				rect_child[ i ].right = pe;

				oMemoryDC.FillRect( &rect_child[ i ], &brush_blue );
			}
		}

		// PLAYBACK LINE (RED)
		//
		for( i = 0 ; i < 4 ; i++ ) {

			ULONG j = m_nFileInfoPlaybackItemNumber[ i ];

			if( j < (ULONG)(m_pFileInfoList[ i ]->GetSize()) ) {

#if( SC590_RECORD_PLAYBACK_METHOD == 0 )

				ULONGLONG n_system_times = m_pFileInfoList[ i ]->ElementAt( j ).m_nFileStartTime + m_nFileInfoPlaybackItemPosition[ i ];
#endif

				LONG po = (LONG)(((n_system_times - n_start_search_system_times) * rect_client.Width()) / (n_stop_search_system_times - n_start_search_system_times));

				LONG pe = po + 1;

				rect_child[ i ].left = po;

				rect_child[ i ].right = pe;

				oMemoryDC.FillRect( &rect_child[ i ], &brush_red );
			}
		}
	}

	GetClientRect( &rect_client );

	pDC->BitBlt( 0, 0, rect_client.Width(), rect_client.Height(), &oMemoryDC, 0, 0, SRCCOPY );

	oMemoryDC.DeleteDC();

	oMemoryBitmap.DeleteObject();

	return TRUE;

	return CWnd::OnEraseBkgnd(pDC);
}

void CFileManagerWindow::OnDestroy() 
{
	CWnd::OnDestroy();

	// TODO: Add your message handler code here

	KillTimer( 0x00000001 );

	KillTimer( 0x00000000 );

	for( ULONG i = 0 ; i < 4 ; i++ ) {

		FREE( m_pFileInfoPlaybackStreamBuffer[ i ] );

		if( m_pFileInfoList[ i ] ) {

			AMESDK_FILE_FREE_FILE_INFO_LIST( m_pFileInfoList[ i ] );

			m_pFileInfoList[ i ] = NULL;
		}
	}
}

int CFileManagerWindow::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	SetTimer( 0x00000000, 15000, NULL ); // 15 SECS (HERE, 1 PIXEL IS 2 MINS)

	SetTimer( 0x00000001, 1, NULL ); // 1 MS

	m_pFileInfoList[ 0 ] = NULL;

	m_pFileInfoList[ 1 ] = NULL;

	m_pFileInfoList[ 2 ] = NULL;

	m_pFileInfoList[ 3 ] = NULL;

	m_nFileInfoPlaybackItemNumber[ 0 ] = 0;

	m_nFileInfoPlaybackItemNumber[ 1 ] = 0;

	m_nFileInfoPlaybackItemNumber[ 2 ] = 0;

	m_nFileInfoPlaybackItemNumber[ 3 ] = 0;

	m_nFileInfoPlaybackItemPosition[ 0 ] = 0;

	m_nFileInfoPlaybackItemPosition[ 1 ] = 0;

	m_nFileInfoPlaybackItemPosition[ 2 ] = 0;

	m_nFileInfoPlaybackItemPosition[ 3 ] = 0;

	m_nFileInfoPlaybackState[ 0 ] = 0x00000000;

	m_nFileInfoPlaybackState[ 1 ] = 0x00000000;

	m_nFileInfoPlaybackState[ 2 ] = 0x00000000;

	m_nFileInfoPlaybackState[ 3 ] = 0x00000000;

	m_nFileInfoPlaybackStreamBufferSize[ 0 ] = 0;

	m_nFileInfoPlaybackStreamBufferSize[ 1 ] = 0;

	m_nFileInfoPlaybackStreamBufferSize[ 2 ] = 0;

	m_nFileInfoPlaybackStreamBufferSize[ 3 ] = 0;

	m_pFileInfoPlaybackStreamBuffer[ 0 ] = (BYTE *)(malloc( 0x00096000 ));

	m_pFileInfoPlaybackStreamBuffer[ 1 ] = (BYTE *)(malloc( 0x00096000 ));

	m_pFileInfoPlaybackStreamBuffer[ 2 ] = (BYTE *)(malloc( 0x00096000 ));

	m_pFileInfoPlaybackStreamBuffer[ 3 ] = (BYTE *)(malloc( 0x00096000 ));

	m_nStartDblClkSystemTime_Timer = 0;

	m_nStartDblClkSystemTime_Playback = 0;

	m_bIsExportRangeSelecting = FALSE;

	m_nStartExportPoint = 0x00000000;

	m_nStopExportPoint = 0x00000000;

	m_nSrcExportDiskNumber = 0;

	m_nDstExportDiskNumber = 0;

	m_pMainDialog = (CSC590Dlg *)(GetParent()->GetParent());

	m_pSetupDialog = (CSetupDialog *)(GetParent());

	return 0;
}

BOOL CFileManagerWindow::ExportFileToDisk( ULONG nDiskNumber )
{
	return FALSE;
}

BOOL CFileManagerWindow::EnumFileInfoFromDisk( ULONG nDiskNumber, BOOL bIsInitialize )
{
	SYSTEMTIME s_system_times; GetLocalTime( &s_system_times );

	ULONGLONG n_start_search_system_times;

	ULONGLONG n_stop_search_system_times;

	SystemTimeToFileTime( &s_system_times, (FILETIME *)(&m_nLastSyncSystemTime) );

	s_system_times.wHour = 0;

	s_system_times.wMinute = 0;

	s_system_times.wSecond = 0;

	s_system_times.wMilliseconds = 0;

	SystemTimeToFileTime( &s_system_times, (FILETIME *)(&m_nStartSearchSystemTime) );

	s_system_times.wHour = 23;

	s_system_times.wMinute = 59;

	s_system_times.wSecond = 59;

	s_system_times.wMilliseconds = 999;

	SystemTimeToFileTime( &s_system_times, (FILETIME *)(&m_nStopSearchSystemTime) );

	n_start_search_system_times = m_nStartSearchSystemTime;

	n_stop_search_system_times = m_nStopSearchSystemTime;

	/////////////////////////////////////////////////////

	for( ULONG i = 0 ; i < 4 ; i++ ) {

		CHAR psz[ MAX_PATH ];

		sprintf( psz, "%C:\\SC590\\CH%02d\\", 'C' + nDiskNumber, i + 1 );		
		
		if( bIsInitialize ) {
			
			m_pFileInfoList[ i ] = AMESDK_FILE_GET_FILE_INFO_LIST( psz, n_start_search_system_times, n_stop_search_system_times );
		}
		else {

			AMESDK_FILE_UPDATE_FILE_INFO_LIST( m_pFileInfoList[ i ], psz, n_start_search_system_times, n_stop_search_system_times );
		}
	}

#if ( SC590_RECORD_PLAYBACK_METHOD == 0 )

	// NOTE!! CUSTOMER SHOULD CHECK/UPDATE THE PRELOAD FILE SOURCE RESOURCE, HERE.

#endif

	Invalidate( TRUE );

	return TRUE;
}

void CFileManagerWindow::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) {

		Invalidate( TRUE );
	}
	if( nIDEvent == 0x00000001 ) {

		CSetupDialog * pSetupDialog = (CSetupDialog *)(GetParent());

		CSC590Dlg *    pMainDialog = (CSC590Dlg *)(pSetupDialog->GetParent());

#if ( SC590_RECORD_PLAYBACK_METHOD == 0 )

		for( ULONG i = 0 ; i < 4 ; i++ ) {

			if( m_nFileInfoPlaybackState[ i ] != 0x00000002 ) { continue ; }

			LONGLONG n_file_length = pMainDialog->OnFileSourceGetMediaLength_FileManagerWindow( i, 0x00000000 ); // UNIT IS 100NS

			LONGLONG n_file_position = pMainDialog->OnFileSourceGetMediaPosition_FileManagerWindow( i, 0x00000000 ); // UNIT IS 100NS

			if( n_file_length == 0 ) { continue ; }

			if( n_file_position < n_file_length ) { m_nFileInfoPlaybackItemPosition[ i ] = n_file_position; continue ; }

			// GOTO NEXT RECORD FILE
			//
			ULONG j = m_nFileInfoPlaybackItemNumber[ i ] + 1;

			if( j < (ULONG)(m_pFileInfoList[ i ]->GetSize()) ) {

				pMainDialog->OnFileSourceDestroy_FileManagerWindow( i );

				pMainDialog->OnFileSourceCreate_FileManagerWindow( i, &(m_pFileInfoList[ i ]->ElementAt( j )) );

				pMainDialog->OnFileSourceSetMediaPlaybackRate_FileManagerWindow( i, 1.000 ); // X0.5, X1.0, X1.5, X2.0, ...

				pMainDialog->OnFileSourceRun_FileManagerWindow( i );

				m_nFileInfoPlaybackItemPosition[ i ] = 0;

				m_nFileInfoPlaybackItemNumber[ i ] = j;

				m_nFileInfoPlaybackState[ i ] = 0x00000002; // KEEP ON PLAYBACK

				Invalidate( TRUE );
			}
			else {

				m_nFileInfoPlaybackItemPosition[ i ] = n_file_position;

				m_nFileInfoPlaybackState[ i ] = 0x00000000; // STOP PLAYBACK
			}
		}

		// NOTE!! CUSTOMER SHOULD USE MULTIPLE THREADS TO REPLACE ON.TIMER() SCHEDULE. THE DEMO PROGRAM COULD CAUSE ONE OUT.OF.SYNC ISSUE FOR MULTIPLE CHANNELS PLAYBACK.

#endif

	}
	CWnd::OnTimer(nIDEvent);
}

void CFileManagerWindow::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default

	CSetupDialog * pSetupDialog = (CSetupDialog *)(GetParent());

	CSC590Dlg *    pMainDialog = (CSC590Dlg *)(pSetupDialog->GetParent());

	CRect          rect_client; GetClientRect( &rect_client );

	ULONGLONG      n_start_search_system_times = m_nStartSearchSystemTime;

	ULONGLONG      n_stop_search_system_times = m_nStopSearchSystemTime;

	ULONGLONG      n_system_times = ((point.x) * (n_stop_search_system_times - n_start_search_system_times)) / (rect_client.Width()) + (n_start_search_system_times);

	BOOL           is_exist[ 4 ] = { FALSE, FALSE, FALSE, FALSE };

	SYSTEMTIME     s_dbclk_system_times; 

	ULONGLONG      n_start_dbclk_system_times = 0;

	ULONGLONG      n_stop_dbclk_system_times = 0;

	ULONGLONG      n_start_playback_system_times = 0xFFFFFFFFFFFFFFFF;

	GetLocalTime( &s_dbclk_system_times );

	SystemTimeToFileTime( &s_dbclk_system_times, (FILETIME *)(&n_start_dbclk_system_times) );

	for( ULONG i = 0 ; i < 4 ; i++ ) {

		for( ULONG j = 0 ; j < (ULONG)(m_pFileInfoList[ i ]->GetSize()) ; j++ ) {

			ULONGLONG n_start_system_time = m_pFileInfoList[ i ]->ElementAt( j ).m_nFileStartTime;

			ULONGLONG n_stop_system_time = m_pFileInfoList[ i ]->ElementAt( j ).m_nFileStopTime;

			LONG po = (LONG)(((n_start_system_time - n_start_search_system_times) * rect_client.Width()) / (n_stop_search_system_times - n_start_search_system_times));

			LONG pe = (LONG)(((n_stop_system_time - n_start_search_system_times) * rect_client.Width()) / (n_stop_search_system_times - n_start_search_system_times));

			if( point.x >= po &&

				point.x <= pe ) {

				is_exist[ i ] = TRUE;

				break;
			}
		}
		if( is_exist[ i ] ) {

#if ( SC590_RECORD_PLAYBACK_METHOD == 0 )

			pMainDialog->OnFileSourceDestroy_FileManagerWindow( i );

			pMainDialog->OnFileSourceCreate_FileManagerWindow( i, &(m_pFileInfoList[ i ]->ElementAt( j )) );

			pMainDialog->OnFileSourcePause_FileManagerWindow( i );

			{	SYSTEMTIME s_dbclk_system_times; GetLocalTime( &s_dbclk_system_times ); // [EASY.SYNC.METHOD]

				SystemTimeToFileTime( &s_dbclk_system_times, (FILETIME *)(&n_stop_dbclk_system_times) );

				ULONGLONG tm = (n_stop_dbclk_system_times - n_start_dbclk_system_times);

				if( (n_system_times + tm) >= (m_pFileInfoList[ i ]->ElementAt( j ).m_nFileStartTime) ) {

					m_nFileInfoPlaybackItemPosition[ i ] = (n_system_times + tm) - (m_pFileInfoList[ i ]->ElementAt( j ).m_nFileStartTime);
				}
				else {

					m_nFileInfoPlaybackItemPosition[ i ] = (0 + tm);
				}
			}
			pMainDialog->OnFileSourceSetMediaPosition_FileManagerWindow( i, m_nFileInfoPlaybackItemPosition[ i ], 0x00000000 ); // UNIT IS 100NS

			pMainDialog->OnFileSourceSetMediaPlaybackRate_FileManagerWindow( i, 1.000 ); // X0.5, X1.0, X1.5, X2.0, ...

			pMainDialog->OnFileSourceRun_FileManagerWindow( i );

			m_nFileInfoPlaybackItemNumber[ i ] = j;

			m_nFileInfoPlaybackState[ i ] = 0x00000002;
#endif

		}
	}
	Invalidate( TRUE );

	CWnd::OnLButtonDblClk(nFlags, point);
}

void CFileManagerWindow::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( m_bIsExportRangeSelecting ) {

		m_nStopExportPoint = point.x;

		Invalidate( TRUE );
	}
	CWnd::OnMouseMove(nFlags, point);
}

void CFileManagerWindow::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	SetCapture();

	m_nStartExportPoint = point.x;

	m_bIsExportRangeSelecting = TRUE;

	CWnd::OnLButtonDown(nFlags, point);
}

void CFileManagerWindow::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	m_bIsExportRangeSelecting = FALSE;

	m_nStopExportPoint = point.x;

	ReleaseCapture();

	CWnd::OnLButtonUp(nFlags, point);
}

BOOL CFileManagerWindow::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	if( pMsg->message == WM_UPDATE_FILE_INFO_LIST ) {

		ULONG i = pMsg->wParam;

		SYSTEMTIME s_system_times; GetLocalTime( &s_system_times );

		ULONGLONG n_start_search_system_times;

		ULONGLONG n_stop_search_system_times;

		SystemTimeToFileTime( &s_system_times, (FILETIME *)(&m_nLastSyncSystemTime) );

		s_system_times.wHour = 0;

		s_system_times.wMinute = 0;

		s_system_times.wSecond = 0;

		s_system_times.wMilliseconds = 0;

		SystemTimeToFileTime( &s_system_times, (FILETIME *)(&m_nStartSearchSystemTime) );

		s_system_times.wHour = 23;

		s_system_times.wMinute = 59;

		s_system_times.wSecond = 59;

		s_system_times.wMilliseconds = 999;

		SystemTimeToFileTime( &s_system_times, (FILETIME *)(&m_nStopSearchSystemTime) );

		n_start_search_system_times = m_nStartSearchSystemTime;

		n_stop_search_system_times = m_nStopSearchSystemTime;

		CHAR psz[ MAX_PATH ]; 

		sprintf( psz, "%C:\\SC590\\CH%02d\\", 'C' + m_pSetupDialog->m_nLargestAvailableDiskNumber, i + 1 );	

		AMESDK_FILE_UPDATE_FILE_INFO_LIST( m_pFileInfoList[ i ], psz, n_start_search_system_times, n_stop_search_system_times );

		Invalidate( TRUE );
	}
	return CWnd::PreTranslateMessage(pMsg);
}
